<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2PubSubNotification extends \Google\Model
{
  /**
   * @var string
   */
  public $detailOfMessage;
  /**
   * @var string
   */
  public $event;
  protected $pubsubConditionType = GooglePrivacyDlpV2DataProfilePubSubCondition::class;
  protected $pubsubConditionDataType = '';
  public $pubsubCondition;
  /**
   * @var string
   */
  public $topic;

  /**
   * @param string
   */
  public function setDetailOfMessage($detailOfMessage)
  {
    $this->detailOfMessage = $detailOfMessage;
  }
  /**
   * @return string
   */
  public function getDetailOfMessage()
  {
    return $this->detailOfMessage;
  }
  /**
   * @param string
   */
  public function setEvent($event)
  {
    $this->event = $event;
  }
  /**
   * @return string
   */
  public function getEvent()
  {
    return $this->event;
  }
  /**
   * @param GooglePrivacyDlpV2DataProfilePubSubCondition
   */
  public function setPubsubCondition(GooglePrivacyDlpV2DataProfilePubSubCondition $pubsubCondition)
  {
    $this->pubsubCondition = $pubsubCondition;
  }
  /**
   * @return GooglePrivacyDlpV2DataProfilePubSubCondition
   */
  public function getPubsubCondition()
  {
    return $this->pubsubCondition;
  }
  /**
   * @param string
   */
  public function setTopic($topic)
  {
    $this->topic = $topic;
  }
  /**
   * @return string
   */
  public function getTopic()
  {
    return $this->topic;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2PubSubNotification::class, 'Google_Service_DLP_GooglePrivacyDlpV2PubSubNotification');
